﻿using System;
using System.Linq;
using System.Net;

namespace REST
{
   class Program
   {
      static void Main(string[] args)
      {
         // die URL zum Dienst
         var serviceUrl = new Uri("http://contoso.de/kunden/_vti_bin/listdata.svc");
         // Erstellung des Kontextes mit dem aktuellen Benutzer
         var ctx = new KundenDaten.KundenDataContext(serviceUrl);
         ctx.Credentials = CredentialCache.DefaultNetworkCredentials;

         // aktuellen Ankündigungen auslesen
         var items = from item in ctx.Ankündigungen
                     where item.LäuftAb >= DateTime.Today
                     select item;
         Console.WriteLine("{0} Elemente gefunden.", items.Count());

         // Eine neue Ankuendigung wird erstellt
         var ankuendigung = new KundenDaten.AnkündigungenItem
                               {
                                  Titel = "Neuer Kunde",
                                  Textkörper = "Der Ansprechpartner ist Hr. Meyer.",
                                  LäuftAb = DateTime.Today.AddDays(7)
                               };
         // Hinzufuegen und Speichern des Elements
         ctx.AddToAnkündigungen(ankuendigung);
         ctx.SaveChanges();
      }
   }
}
